package gov.va.med.mhv.bluebutton.essapi.service;

import java.util.List;

import gov.va.med.mhv.bluebutton.essapi.transfer.DataClassTO;
import gov.va.med.mhv.bluebutton.essapi.transfer.FacilityExtractStatusesTO;
import gov.va.med.mhv.bluebutton.essapi.transfer.GenerateReportTO;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

public interface BBAPIService {

	@POST
	@Path("/bbreport")
	public String getBlueButtonReport();

	@POST
	@Path("/refresh")
	public Response doRefresh();

	@GET
	@Path("/extractstatus")
	public FacilityExtractStatusesTO getExtractStatus();

	@GET
	@Path("/bbreport/{filetype}")
	public Response getBBReport(@javax.ws.rs.PathParam("filetype") String filetype);

	@POST
	@Path("/generate")
	public Response generateBBReport(GenerateReportTO genRepTO);

	@GET
	@Path("/geteligibledataclass")
	public DataClassTO getEligibleDataClasses();
	
}
